/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadsCorePoolTest
extends ContextTestSupport {
    private String beforeThreadName;
    private volatile String afterThreadName;

    @Test
    public void testThreadsCorePool() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)this.beforeThreadName, (String)"The main thread name should be already properly set!");
        Assertions.assertNotNull((Object)this.afterThreadName, (String)"The camel thread name should be already properly set!");
        Assertions.assertFalse((boolean)this.beforeThreadName.equalsIgnoreCase(this.afterThreadName), (String)"Should use different threads");
    }

    @Test
    public void testThreadsCorePoolBuilder() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)this.beforeThreadName, (String)"The main thread name should be already properly set!");
        Assertions.assertNotNull((Object)this.afterThreadName, (String)"The camel thread name should be already properly set!");
        Assertions.assertFalse((boolean)this.beforeThreadName.equalsIgnoreCase(this.afterThreadName), (String)"Should use different threads");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThreadsCorePoolTest.this.context.setTracing(Boolean.valueOf(true));
                ((ThreadsDefinition)((ThreadsDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) {
                        ThreadsCorePoolTest.this.beforeThreadName = Thread.currentThread().getName();
                    }
                })).threads(5).process(new Processor(){

                    public void process(Exchange exchange) {
                        ThreadsCorePoolTest.this.afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:result");
                ((ThreadsDefinition)((RouteDefinition)this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) {
                        ThreadsCorePoolTest.this.beforeThreadName = Thread.currentThread().getName();
                    }
                })).threads().poolSize(5).process(new Processor(){

                    public void process(Exchange exchange) {
                        ThreadsCorePoolTest.this.afterThreadName = Thread.currentThread().getName();
                    }
                })).to("mock:result");
            }
        };
    }
}

