/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.SupervisingRouteController;
import org.junit.jupiter.api.Test;

public class SupervisingRouteControllerSplitOnExceptionTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        SupervisingRouteController src = context.getRouteController().supervising();
        src.setBackOffDelay(25L);
        src.setBackOffMaxAttempts(3L);
        src.setInitialDelay(100L);
        src.setThreadPoolSize(1);
        return context;
    }

    @Test
    public void testSupervising() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:uk").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<hello>World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((SplitDefinition)this.onException(new Class[0]).handled(true).split().method(SupervisingRouteControllerSplitOnExceptionTest.class, "mySplit")).streaming().log("Exception occurred")).to("mock:error");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.xpath("/person/city = 'London'")).log("UK message")).to("mock:uk")).otherwise().log("Other message")).to("mock:other");
            }
        };
    }

    public static List<Message> mySplit(@Body Message inputMessage) {
        ArrayList<Message> outputMessages = new ArrayList<Message>();
        Message outputMessage = inputMessage.copy();
        outputMessage.setBody(inputMessage.getBody());
        outputMessages.add(outputMessage);
        return outputMessages;
    }
}

