/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.util.xml.StringSource;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StreamSourceContentBasedRouterTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;

    @Test
    public void testSendStreamSource() throws Exception {
        this.x.expectedMessageCount(1);
        this.y.expectedMessageCount(1);
        this.sendBody("direct:start", new StreamSource(new StringReader("<message>xx</message>")));
        this.sendBody("direct:start", new StreamSource(new StringReader("<message>yy</message>")));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendStringSource() throws Exception {
        this.x.expectedMessageCount(1);
        this.y.expectedMessageCount(1);
        this.sendBody("direct:start", new StringSource("<message>xx</message>"));
        this.sendBody("direct:start", new StringSource("<message>yy</message>"));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").streamCaching().choice().when().xpath("/message/text() = 'xx'")).to("mock:x")).when().xpath("/message/text() = 'yy'")).to("mock:y");
            }
        };
    }
}

