/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class StreamCachingXPathRouteTest
extends ContextTestSupport {
    @Test
    public void testByteArrayInputStream() throws Exception {
        this.getMockEndpoint("mock:english").expectedBodiesReceived(new Object[]{"<hello/>"});
        this.getMockEndpoint("mock:dutch").expectedBodiesReceived(new Object[]{"<hallo/>"});
        this.getMockEndpoint("mock:german").expectedBodiesReceived(new Object[]{"<hallo/>"});
        this.getMockEndpoint("mock:french").expectedBodiesReceived(new Object[]{"<hellos/>"});
        this.template.sendBody("direct:a", (Object)new ByteArrayInputStream("<hello/>".getBytes()));
        this.template.sendBody("direct:a", (Object)new ByteArrayInputStream("<hallo/>".getBytes()));
        this.template.sendBody("direct:a", (Object)new ByteArrayInputStream("<hellos/>".getBytes()));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                StreamCachingXPathRouteTest.this.context.setStreamCaching(Boolean.valueOf(true));
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when((Predicate)this.xpath("//hello")).to("mock:english")).when((Predicate)this.xpath("//hallo")).to(new String[]{"mock:dutch", "mock:german"})).otherwise().to("mock:french");
            }
        };
    }
}

