/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamCachingVariableTest
extends ContextTestSupport {
    private static final String TEST_FILE = "src/test/resources/org/apache/camel/util/foo.txt";

    @Test
    public void testStreamCaching() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"foo"});
        File file = new File(TEST_FILE);
        FileInputStreamCache cache = new FileInputStreamCache(file);
        this.template.sendBody("direct:start", (Object)cache);
        this.assertMockEndpointsSatisfied();
        cache = new FileInputStreamCache(file);
        this.context.setVariable("myKey2", (Object)cache);
        String data = (String)this.context.getVariable("myKey2", String.class);
        Assertions.assertEquals((Object)"foo", (Object)data);
        data = (String)this.context.getVariable("myKey2", String.class);
        Assertions.assertEquals((Object)"foo", (Object)data);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").setVariable("myKey", (Expression)this.simple("${body}"))).process(e -> {
                    String data = (String)e.getVariable("myKey", String.class);
                    Assertions.assertEquals((Object)"foo", (Object)data);
                })).process(e -> {
                    String data = (String)e.getVariable("myKey", String.class);
                    Assertions.assertEquals((Object)"foo", (Object)data);
                })).to("mock:result");
            }
        };
    }
}

