/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamCachingSpoolDirectoryQuarkusTest
extends ContextTestSupport {
    private final MyCustomSpoolRule spoolRule = new MyCustomSpoolRule();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        MyCamelContext context = new MyCamelContext(false);
        context.disableJMX();
        context.getCamelContextExtension().setRegistry(this.createCamelRegistry());
        return context;
    }

    @Test
    public void testByteArrayInputStream() throws Exception {
        this.getMockEndpoint("mock:english").expectedBodiesReceived(new Object[]{"<hello/>"});
        this.getMockEndpoint("mock:dutch").expectedBodiesReceived(new Object[]{"<hallo/>"});
        this.getMockEndpoint("mock:german").expectedBodiesReceived(new Object[]{"<hallo/>"});
        this.getMockEndpoint("mock:french").expectedBodiesReceived(new Object[]{"<hellos/>"});
        this.template.sendBody("direct:a", (Object)new MyInputStream(new ByteArrayInputStream("<hello/>".getBytes())));
        this.spoolRule.setSpool(true);
        this.template.sendBody("direct:a", (Object)new MyInputStream(new ByteArrayInputStream("<hallo/>".getBytes())));
        this.template.sendBody("direct:a", (Object)new MyInputStream(new ByteArrayInputStream("<hellos/>".getBytes())));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                final Path path = StreamCachingSpoolDirectoryQuarkusTest.this.testDirectory();
                StreamCachingSpoolDirectoryQuarkusTest.this.context.getStreamCachingStrategy().setSpoolDirectory(path.toFile());
                StreamCachingSpoolDirectoryQuarkusTest.this.context.getStreamCachingStrategy().setSpoolEnabled(true);
                StreamCachingSpoolDirectoryQuarkusTest.this.context.getStreamCachingStrategy().addSpoolRule((StreamCachingStrategy.SpoolRule)StreamCachingSpoolDirectoryQuarkusTest.this.spoolRule);
                StreamCachingSpoolDirectoryQuarkusTest.this.context.getStreamCachingStrategy().setAnySpoolRules(true);
                StreamCachingSpoolDirectoryQuarkusTest.this.context.setStreamCaching(Boolean.valueOf(true));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:a").choice().when((Predicate)this.xpath("//hello")).to("mock:english")).when((Predicate)this.xpath("//hallo")).to(new String[]{"mock:dutch", "mock:german"})).otherwise().to("mock:french")).end().process(new Processor(){

                    public void process(Exchange exchange) {
                        if (StreamCachingSpoolDirectoryQuarkusTest.this.spoolRule.isSpool()) {
                            String[] names = path.toFile().list();
                            Assertions.assertNotNull((Object)names, (String)("Should be able to list files in " + String.valueOf(path)));
                            Assertions.assertEquals((int)1, (int)names.length, (String)"There should be a cached spool file");
                        }
                    }
                });
            }
        };
    }

    private static final class MyCustomSpoolRule
    implements StreamCachingStrategy.SpoolRule {
        private volatile boolean spool;

        private MyCustomSpoolRule() {
        }

        public boolean shouldSpoolCache(long length) {
            return this.spool;
        }

        public boolean isSpool() {
            return this.spool;
        }

        public void setSpool(boolean spool) {
            this.spool = spool;
        }

        public String toString() {
            return "MyCustomSpoolRule";
        }
    }

    private static class MyCamelContext
    extends DefaultCamelContext {
        public MyCamelContext(boolean init) {
            super(init);
        }

        public ManagementNameStrategy getManagementNameStrategy() {
            return null;
        }
    }

    private static final class MyInputStream
    extends FilterInputStream {
        private MyInputStream(InputStream in) {
            super(in);
        }
    }
}

