/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamCachingInOutTest
extends ContextTestSupport {
    private static final String TEST_FILE = "org/apache/camel/processor/simple.txt";

    @Test
    public void testStreamCachingPerRoute() throws Exception {
        MockEndpoint c = this.getMockEndpoint("mock:c");
        c.expectedMessageCount(1);
        InputStream message = this.getTestFileStream();
        this.template.sendBody("direct:c", (Object)message);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"James,Guillaume,Hiram,Rob,Roman", (Object)c.assertExchangeReceived(0).getIn().getBody(String.class));
    }

    @Test
    public void testStreamCachingPerRouteWithDirecVM() throws Exception {
        MockEndpoint e = this.getMockEndpoint("mock:e");
        e.expectedMessageCount(1);
        InputStream message = this.getTestFileStream();
        this.template.sendBody("direct:e", (Object)message);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"James,Guillaume,Hiram,Rob,Roman", (Object)e.assertExchangeReceived(0).getIn().getBody(String.class));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                StreamCachingInOutTest.this.context.getStreamCachingStrategy().setSpoolThreshold(1L);
                ((RouteDefinition)((RouteDefinition)this.from("direct:c").noStreamCaching().to("direct:d")).convertBodyTo(String.class)).to("mock:c");
                this.from("direct:d").streamCaching().process((Processor)new TestProcessor());
                ((RouteDefinition)((RouteDefinition)this.from("direct:e").noStreamCaching().to("direct:f")).convertBodyTo(String.class)).to("mock:e");
                this.from("direct:f").streamCaching().process((Processor)new TestProcessor());
            }
        };
    }

    private InputStream getTestFileStream() {
        InputStream answer = this.getClass().getClassLoader().getResourceAsStream(TEST_FILE);
        Assertions.assertNotNull((Object)answer, (String)"Should have found the file: org/apache/camel/processor/simple.txt on the classpath");
        return answer;
    }

    private static class TestProcessor
    implements Processor {
        private TestProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            while (is.available() > 0) {
                is.read();
            }
            is.close();
        }
    }
}

