/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class StreamCachingChoiceTest
extends ContextTestSupport {
    private static final String TEST_FILE = "src/test/resources/org/apache/camel/converter/stream/test.xml";

    @Test
    public void testStreamCaching() throws Exception {
        this.getMockEndpoint("mock:paris").expectedMessageCount(0);
        this.getMockEndpoint("mock:madrid").expectedMessageCount(0);
        this.getMockEndpoint("mock:london").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        File file = new File(TEST_FILE);
        FileInputStreamCache cache = new FileInputStreamCache(file);
        this.template.sendBody("direct:start", (Object)cache);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().simple("${body} contains 'Paris'")).to("mock:paris")).when().simple("${body} contains 'London'")).to("mock:london")).otherwise().to("mock:other")).end().choice().when().simple("${body} contains 'Paris'")).to("mock:paris")).when().simple("${body} contains 'Madrid'")).to("mock:madrid")).otherwise().to("mock:other")).end();
            }
        };
    }
}

