/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.StreamCache;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamCachingAllowDenyTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAllow() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                StreamCachingAllowDenyTest.this.context.getStreamCachingStrategy().setAllowClasses(new Class[]{ByteArrayInputStream.class});
                this.from("direct:a").to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new ByteArrayInputStream("Hello World".getBytes()));
        this.assertMockEndpointsSatisfied();
        Assertions.assertInstanceOf(StreamCache.class, (Object)((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody());
        Assertions.assertEquals((Object)"Hello World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
        a.reset();
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new StringReader("Bye World"));
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)(((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody() instanceof StreamCache));
        Assertions.assertEquals((Object)"Bye World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
    }

    @Test
    public void testDeny() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                StreamCachingAllowDenyTest.this.context.getStreamCachingStrategy().setDenyClasses(new Class[]{ByteArrayInputStream.class});
                this.from("direct:a").to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new ByteArrayInputStream("Hello World".getBytes()));
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)(((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody() instanceof StreamCache));
        Assertions.assertEquals((Object)"Hello World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
        a.reset();
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new StringReader("Bye World"));
        this.assertMockEndpointsSatisfied();
        Assertions.assertInstanceOf(StreamCache.class, (Object)((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody());
        Assertions.assertEquals((Object)"Bye World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
    }

    @Test
    public void testAllowAndDeny() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                StreamCachingAllowDenyTest.this.context.getStreamCachingStrategy().setAllowClasses(new Class[]{ByteArrayInputStream.class});
                StreamCachingAllowDenyTest.this.context.getStreamCachingStrategy().setDenyClasses(new Class[]{Reader.class});
                this.from("direct:a").to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new ByteArrayInputStream("Hello World".getBytes()));
        this.assertMockEndpointsSatisfied();
        Assertions.assertInstanceOf(StreamCache.class, (Object)((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody());
        Assertions.assertEquals((Object)"Hello World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
        a.reset();
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new StringReader("Bye World"));
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)(((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody() instanceof StreamCache));
        Assertions.assertEquals((Object)"Bye World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
    }

    @Test
    public void testDualDeny() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                StreamCachingAllowDenyTest.this.context.getStreamCachingStrategy().setDenyClasses(new Class[]{ByteArrayInputStream.class, Reader.class});
                this.from("direct:a").to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new ByteArrayInputStream("Hello World".getBytes()));
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)(((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody() instanceof StreamCache));
        Assertions.assertEquals((Object)"Hello World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
        a.reset();
        a.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)new StringReader("Bye World"));
        this.assertMockEndpointsSatisfied();
        Assertions.assertFalse((boolean)(((Exchange)a.getReceivedExchanges().get(0)).getMessage().getBody() instanceof StreamCache));
        Assertions.assertEquals((Object)"Bye World", (Object)a.assertExchangeReceived(0).getIn().getBody(String.class));
    }
}

