/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.converter.stream.ByteArrayInputStreamCache;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.TypeConverterSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamCacheInternalErrorTest
extends ContextTestSupport {
    private final BodyToStreamCacheConverter converter = new BodyToStreamCacheConverter();

    @Test
    public void testOk() throws Exception {
        this.converter.reset();
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:a").message(0).body()).isInstanceOf(StreamCache.class);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:b").message(0).body()).isInstanceOf(StreamCache.class);
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:c").message(0).body()).isInstanceOf(StreamCache.class);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isInstanceOf(StreamCache.class);
        this.getMockEndpoint("mock:exception").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)new MyBody("Hello World"));
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.converter.getInvoked());
    }

    @Test
    public void testError() throws Exception {
        this.converter.reset();
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:error").message(0).body()).isInstanceOf(MyBody.class);
        ((MockValueBuilder)this.getMockEndpoint("mock:exception").message(0).body()).contains((Object)"Handled big error due to Error during type conversion from type: org.apache.camel.processor.StreamCacheInternalErrorTest.MyBody");
        ((MockValueBuilder)this.getMockEndpoint("mock:exception").message(0).body()).contains((Object)"Kaboom");
        this.template.sendBody("direct:start", (Object)new MyBody("Kaboom"));
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.converter.getInvoked());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                StreamCacheInternalErrorTest.this.context.getTypeConverterRegistry().addTypeConverter(StreamCache.class, MyBody.class, (TypeConverter)StreamCacheInternalErrorTest.this.converter);
                StreamCacheInternalErrorTest.this.context.setStreamCaching(Boolean.valueOf(true));
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).maximumRedeliveries(2).handled(true).to("mock:error")).setBody((Expression)this.simple("Handled big error due to ${exception.message}"))).to("mock:exception");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").tracing().to("mock:a")).to("mock:b")).to("mock:c")).to("mock:result");
            }
        };
    }

    private static class BodyToStreamCacheConverter
    extends TypeConverterSupport {
        private int invoked;

        private BodyToStreamCacheConverter() {
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            return this.tryConvertTo(type, exchange, value);
        }

        public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            ++this.invoked;
            String str = value.toString();
            if ("Kaboom".equals(str)) {
                throw new IllegalArgumentException("Kaboom");
            }
            byte[] data = str.getBytes();
            return (T)new ByteArrayInputStreamCache(new ByteArrayInputStream(data));
        }

        public int getInvoked() {
            return this.invoked;
        }

        public void reset() {
            this.invoked = 0;
        }
    }

    private static class MyBody {
        private final String body;

        public MyBody(String body) {
            this.body = body;
        }

        public String toString() {
            return this.body;
        }
    }
}

