/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StickyLoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().sticky((Expression)this.header("foo")).to(new String[]{"mock:x", "mock:y", "mock:z"});
            }
        };
    }

    @Test
    public void testSticky() throws Exception {
        this.x.expectedBodiesReceived(new Object[]{"A", "D", "F"});
        this.y.expectedBodiesReceived(new Object[]{"B", "C", "G", "H"});
        this.z.expectedBodiesReceived(new Object[]{"E"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "foo", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "foo", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "foo", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "foo", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "foo", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "foo", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"G", "foo", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"H", "foo", (Object)2);
        this.assertMockEndpointsSatisfied();
    }
}

