/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StepEventNotifierTest
extends ContextTestSupport {
    private final MyEventNotifier notifier = new MyEventNotifier();

    @Test
    public void testStepEventNotifier() throws Exception {
        this.context.addService((Object)this.notifier);
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        Assertions.assertEquals((int)0, (int)this.notifier.getEvents().size());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.notifier.getEvents().size());
        StepEventNotifierTest.assertIsInstanceOf(CamelEvent.StepStartedEvent.class, this.notifier.getEvents().get(0));
        StepEventNotifierTest.assertIsInstanceOf(CamelEvent.StepCompletedEvent.class, this.notifier.getEvents().get(1));
        StepEventNotifierTest.assertIsInstanceOf(CamelEvent.StepStartedEvent.class, this.notifier.getEvents().get(2));
        StepEventNotifierTest.assertIsInstanceOf(CamelEvent.StepCompletedEvent.class, this.notifier.getEvents().get(3));
        Assertions.assertEquals((Object)"foo", (Object)((CamelEvent.StepEvent)this.notifier.getEvents().get(0)).getStepId());
        Assertions.assertEquals((Object)"foo", (Object)((CamelEvent.StepEvent)this.notifier.getEvents().get(1)).getStepId());
        Assertions.assertEquals((Object)"bar", (Object)((CamelEvent.StepEvent)this.notifier.getEvents().get(2)).getStepId());
        Assertions.assertEquals((Object)"bar", (Object)((CamelEvent.StepEvent)this.notifier.getEvents().get(3)).getStepId());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((StepDefinition)((StepDefinition)((StepDefinition)((StepDefinition)this.from("direct:start").step("foo").to("log:foo")).to("mock:foo")).end().step("bar").to("log:bar")).to("mock:bar")).end().to("mock:result");
            }
        };
    }

    private static class MyEventNotifier
    extends EventNotifierSupport {
        private final List<CamelEvent> events = new ArrayList<CamelEvent>();

        public MyEventNotifier() {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreExchangeEvents(true);
            this.setIgnoreRouteEvents(true);
            this.setIgnoreServiceEvents(true);
            this.setIgnoreStepEvents(false);
        }

        public void notify(CamelEvent event) {
            this.events.add(event);
        }

        public List<CamelEvent> getEvents() {
            return this.events;
        }
    }
}

