/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StepEventNotifierOneOutputTest
extends ContextTestSupport {
    private final MyEventNotifier notifier = new MyEventNotifier();

    @Test
    public void testStepEventNotifier() throws Exception {
        this.context.addService((Object)this.notifier);
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        Assertions.assertEquals((int)0, (int)this.notifier.getEvents().size());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.notifier.getEvents().size());
        StepEventNotifierOneOutputTest.assertIsInstanceOf(CamelEvent.StepStartedEvent.class, this.notifier.getEvents().get(0));
        StepEventNotifierOneOutputTest.assertIsInstanceOf(CamelEvent.StepCompletedEvent.class, this.notifier.getEvents().get(1));
        Assertions.assertEquals((Object)"foo", (Object)((CamelEvent.StepEvent)this.notifier.getEvents().get(0)).getStepId());
        Assertions.assertEquals((Object)"foo", (Object)((CamelEvent.StepEvent)this.notifier.getEvents().get(1)).getStepId());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((StepDefinition)this.from("direct:start").step("foo").to("mock:foo")).end();
            }
        };
    }

    private static class MyEventNotifier
    extends EventNotifierSupport {
        private final List<CamelEvent> events = new ArrayList<CamelEvent>();

        public MyEventNotifier() {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreExchangeEvents(true);
            this.setIgnoreRouteEvents(true);
            this.setIgnoreServiceEvents(true);
            this.setIgnoreStepEvents(false);
        }

        public void notify(CamelEvent event) {
            this.events.add(event);
        }

        public List<CamelEvent> getEvents() {
            return this.events;
        }
    }
}

