/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.support.builder.Namespaces;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterWithXqueryTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Namespaces namespaces = new Namespaces("one", "http://camel.apache.org/schema/one");
                ((SplitDefinition)this.from("direct:endpoint").split().xpath("//one:other", namespaces)).to("mock:result");
            }
        };
    }

    @Test
    public void testSenderXmlData() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.reset();
        result.expectedMessageCount(4);
        String xmlData = "<workflow id=\"12345\" xmlns=\"http://camel.apache.org/schema/one\" xmlns:two=\"http://camel.apache.org/schema/two\"><person><name>Willem</name></person> <other><two:test>One</two:test></other><other><two:test>Two</two:test></other><other><test>Three</test></other><other><test>Foure</test></other></workflow>";
        this.template.sendBody("direct:endpoint", (Object)xmlData);
        this.assertMockEndpointsSatisfied();
        for (Exchange exchange : result.getExchanges()) {
            String message = (String)exchange.getIn().getBody(String.class);
            this.log.debug("The message is {}", (Object)message);
            Assertions.assertEquals((int)0, (int)message.indexOf("<other"), (String)"The split message should start with <other");
        }
    }
}

