/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class SplitterWithScannerIoExceptionTest
extends ContextTestSupport {
    @Test
    public void testSplitterStreamingWithError() throws Exception {
        Assumptions.assumeFalse((boolean)SplitterWithScannerIoExceptionTest.isJavaVendor("ibm"));
        this.getMockEndpoint("mock:a").expectedMinimumMessageCount(250);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").setSleepForEmptyTest(3000L);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
                ((ExpressionNode)this.from("file://src/test/data?fileName=crm.sample.csv&noop=true&charset=UTF-8").split((Expression)this.body().tokenize("\n")).streaming().to("mock:a")).end().to("mock:b");
            }
        };
    }
}

