/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterWithCustomThreadPoolExecutorTest
extends ContextTestSupport {
    protected final ThreadPoolExecutor customThreadPoolExecutor = new ThreadPoolExecutor(8, 16, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    @Test
    public void testSplitterWithCustomThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.getSplitter().getExecutorServiceBean();
        if (threadPoolExecutor == null) {
            threadPoolExecutor = (ThreadPoolExecutor)this.context.getRegistry().lookupByNameAndType(this.getSplitter().getExecutorService(), ThreadPoolExecutor.class);
        }
        Assertions.assertEquals((int)threadPoolExecutor.getCorePoolSize(), (int)this.getThreadPoolExecutor().getCorePoolSize());
        Assertions.assertEquals((int)threadPoolExecutor.getMaximumPoolSize(), (int)this.getThreadPoolExecutor().getMaximumPoolSize());
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this.customThreadPoolExecutor;
    }

    protected SplitDefinition getSplitter() {
        RouteDefinition routeType;
        SplitDefinition result = null;
        List routeDefinitions = this.context.getRouteDefinitions();
        Iterator iterator = routeDefinitions.iterator();
        while (iterator.hasNext() && (result = this.firstSplitterType((routeType = (RouteDefinition)iterator.next()).getOutputs())) == null) {
        }
        return result;
    }

    protected SplitDefinition firstSplitterType(List<ProcessorDefinition<?>> outputs) {
        SplitDefinition splitDefinition;
        ProcessorDefinition<?> processorType;
        SplitDefinition result = null;
        Iterator<ProcessorDefinition<?>> iterator = outputs.iterator();
        while (iterator.hasNext() && (result = (processorType = iterator.next()) instanceof SplitDefinition ? (splitDefinition = (SplitDefinition)processorType) : this.firstSplitterType(processorType.getOutputs())) == null) {
        }
        return result;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:parallel-custom-pool").split((Expression)this.body().tokenize(",")).parallelProcessing().executorService((ExecutorService)SplitterWithCustomThreadPoolExecutorTest.this.customThreadPoolExecutor).to("mock:result");
            }
        };
    }
}

