/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.engine.DefaultStreamCachingStrategy;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.StreamCachingStrategy;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SplitterWireTapStreamCacheTest
extends ContextTestSupport {
    private MockEndpoint startEnd;
    private MockEndpoint splitEnd;
    private MockEndpoint wiretapEnd;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.startEnd = this.getMockEndpoint("mock:startEnd");
        this.splitEnd = this.getMockEndpoint("mock:splitEnd");
        this.wiretapEnd = this.getMockEndpoint("mock:wireTapEnd");
    }

    @Test
    public void testWireTapAfterSplitDeletesStreamCacheFileWhenSplitFinishes() throws Exception {
        this.startEnd.expectedMessageCount(1);
        this.splitEnd.expectedMessageCount(1);
        this.wiretapEnd.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"text");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DefaultStreamCachingStrategy streamCachingStrategy = new DefaultStreamCachingStrategy();
                streamCachingStrategy.setSpoolThreshold(1L);
                SplitterWireTapStreamCacheTest.this.context.setStreamCachingStrategy((StreamCachingStrategy)streamCachingStrategy);
                SplitterWireTapStreamCacheTest.this.context.setStreamCaching(Boolean.valueOf(true));
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.bodyAs(String.class).tokenize()).to("direct:split")).to("mock:startEnd")).end();
                this.from("direct:split").wireTap("direct:wireTap").delay(1000L).to("mock:splitEnd");
                ((RouteDefinition)this.from("direct:wireTap").setBody((Expression)this.constant(((Object)((Object)this)).getClass().getResourceAsStream("/log4j2.properties")))).delay(3000L).to("mock:wireTapEnd");
            }
        };
    }
}

