/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterUseOriginalPropagateExceptionSubRouteTest
extends ContextTestSupport {
    private final MyEventNotifier notifier = new MyEventNotifier();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    @Test
    public void testUseOriginalPropagateException() throws Exception {
        Assertions.assertEquals((int)0, (int)this.notifier.getErrors());
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Hello", "World"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello,Kaboom,World");
            Assertions.fail((String)"Should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)2, (int)this.notifier.getErrors());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((OnCompletionDefinition)this.from("direct:start").onCompletion().process(e -> {
                    Exception caught = e.getException();
                    Assertions.assertNull((Object)caught);
                    caught = (Exception)e.getProperty("CamelExceptionCaught", Exception.class);
                    TestSupport.assertIsInstanceOf(IllegalArgumentException.class, caught);
                    Assertions.assertEquals((Object)"Forced error", (Object)caught.getMessage());
                })).end().split((Expression)this.body()).aggregationStrategy(AggregationStrategies.useOriginal((boolean)true)).to("direct:sub")).end().to("mock:result");
                ((ExpressionNode)this.from("direct:sub").errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L)).filter((Predicate)this.simple("${body} == 'Kaboom'")).throwException((Exception)new IllegalArgumentException("Forced error"))).end().to("mock:line");
            }
        };
    }

    private static class MyEventNotifier
    extends EventNotifierSupport {
        private int errors;

        private MyEventNotifier() {
        }

        public void notify(CamelEvent event) {
            ++this.errors;
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.ExchangeFailedEvent;
        }

        public int getErrors() {
            return this.errors;
        }
    }
}

