/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterUseOriginalNotPropagateExceptionTest
extends ContextTestSupport {
    private final MyEventNotifier notifier = new MyEventNotifier();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    @Test
    public void testUseOriginalNotPropagateException() throws Exception {
        Assertions.assertEquals((int)0, (int)this.notifier.getErrors());
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Hello", "World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello,Kaboom,World"});
        try {
            this.template.sendBody("direct:start", (Object)"Hello,Kaboom,World");
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not fail");
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.notifier.getErrors());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((OnCompletionDefinition)this.from("direct:start").onCompletion().process(e -> {
                    Exception caught = e.getException();
                    Assertions.assertNull((Object)caught);
                    caught = (Exception)e.getProperty("CamelExceptionCaught", Exception.class);
                    Assertions.assertNull((Object)caught);
                })).end().split((Expression)this.body()).aggregationStrategy(AggregationStrategies.useOriginal((boolean)false)).filter((Predicate)this.simple("${body} == 'Kaboom'")).throwException((Exception)new IllegalArgumentException("Forced error"))).end().to("mock:line").end().to("mock:result");
            }
        };
    }

    private static class MyEventNotifier
    extends EventNotifierSupport {
        private int errors;

        private MyEventNotifier() {
        }

        public void notify(CamelEvent event) {
            ++this.errors;
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.ExchangeFailedEvent;
        }

        public int getErrors() {
            return this.errors;
        }
    }
}

