/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SplitterUoWIssueTest
extends ContextTestSupport {
    @Test
    public void testSplitterUoWIssue() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"A,B,C,D,E", "CamelFileName", (Object)"splitme.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitterTwoFilesUoWIssue() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E", "F,G,H,I"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"A,B,C,D,E", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"F,G,H,I", "CamelFileName", (Object)"b.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from(SplitterUoWIssueTest.this.fileUri("?initialDelay=0&delay=10&delete=true&sortBy=file:name")).split((Expression)this.body().tokenize(",")).to("seda:queue")).end().log("End of file ${file:name}").to("mock:result");
                ((RouteDefinition)this.from("seda:queue").log("Token: ${body}")).to("mock:foo");
            }
        };
    }
}

