/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SplitterStreamingUoWIssueTest
extends ContextTestSupport {
    @Test
    public void testSplitterStreamingUoWIssue() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"A,B,C,D,E", "CamelFileName", (Object)"splitme.txt");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitterTwoFilesStreamingUoWIssue() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E", "F,G,H,I"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"A,B,C,D,E", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"F,G,H,I", "CamelFileName", (Object)"b.txt");
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from(SplitterStreamingUoWIssueTest.this.fileUri("?initialDelay=0&delay=10&delete=true&sortBy=file:name")).routeId("start").autoStartup(false).log("Start of file ${file:name}")).split((Expression)this.body().tokenize(",")).streaming().process(e -> this.log.info("Stackframe size: {}", (Object)Thread.currentThread().getStackTrace().length))).to("seda:queue")).end().log("End of file ${file:name}").to("mock:result");
                ((RouteDefinition)this.from("seda:queue").log("Token: ${body}")).to("mock:foo");
            }
        };
    }
}

