/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterStreamingStopOnExceptionErrorHandlingTest
extends ContextTestSupport {
    @Test
    public void testSplitterStreamingNoError() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A,B,C,D,E"});
        this.template.sendBody("direct:start", (Object)"A,B,C,D,E");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitterStreamingWithError() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"A", "B", "Kaboom"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"A", "B"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"A,B,Kaboom,D,E");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            SplitterStreamingStopOnExceptionErrorHandlingTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
            Assertions.assertEquals((Object)"Cannot do this", (Object)e.getCause().getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).streaming().stopOnException().to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Cannot do this");
                        }
                    }
                })).to("mock:b")).end().to("mock:result");
            }
        };
    }
}

