/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterStreamCacheTest
extends ContextTestSupport {
    private static final String TEST_FILE = "org/apache/camel/converter/stream/test.xml";
    protected final int numMessages = 200;

    @Test
    public void testSendStreamSource() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(200);
        for (int c = 0; c < 200; ++c) {
            this.template.sendBody("seda:parallel", (Object)new StreamSource(this.getTestFileStream()));
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SplitterStreamCacheTest.this.context.getStreamCachingStrategy().setSpoolDirectory(SplitterStreamCacheTest.this.testDirectory().toFile());
                SplitterStreamCacheTest.this.context.getStreamCachingStrategy().setSpoolThreshold(-1L);
                this.from("seda:parallel?concurrentConsumers=5").streamCaching().split((Expression)this.xpath("//person/city")).to("mock:result");
            }
        };
    }

    protected InputStream getTestFileStream() {
        InputStream answer = this.getClass().getClassLoader().getResourceAsStream(TEST_FILE);
        Assertions.assertNotNull((Object)answer, (String)"Should have found the file: org/apache/camel/converter/stream/test.xml on the classpath");
        return answer;
    }
}

