/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterStopOnExceptionWithOnExceptionTest
extends ContextTestSupport {
    @Test
    public void testSplitStopOnExceptionOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitStopOnExceptionStop1() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:start", (Object)"Kaboom,Hello World,Bye World", String.class);
        Assertions.assertEquals((Object)"Damn Forced", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitStopOnExceptionStop2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World,Kaboom,Bye World", String.class);
        Assertions.assertEquals((Object)"Damn Forced", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitStopOnExceptionStop3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World,Bye World,Kaboom", String.class);
        Assertions.assertEquals((Object)"Damn Forced", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).to("mock:handled")).transform((Expression)this.simple("Damn ${exception.message}"));
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).stopOnException().process((Processor)new MyProcessor())).to("mock:split");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kaboom".equals(body)) {
                throw new IllegalArgumentException("Forced");
            }
        }
    }
}

