/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class SplitterSkipTest
extends ContextTestSupport {
    @Test
    public void testSplitterSkip() throws Exception {
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"C", "D", "E"});
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        data.add("D");
        data.add("E");
        this.template.sendBody("direct:start", data);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitterEmpty() throws Exception {
        this.getMockEndpoint("mock:line").expectedMessageCount(0);
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        this.template.sendBody("direct:start", data);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitterEmptyAgain() throws Exception {
        this.getMockEndpoint("mock:line").expectedMessageCount(0);
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        this.template.sendBody("direct:start", data);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.simple("${skip(2)}")).to("mock:line");
            }
        };
    }
}

