/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class SplitterSingleMapTest
extends ContextTestSupport {
    @Test
    public void testSplitSingleMap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:line");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(Map.class);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("123", "Hello World");
        map.put("789", "Bye World");
        this.template.sendBody("direct:start", (Object)new Order(44, map));
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.simple("${body.data}"), "single").to("mock:line")).end();
            }
        };
    }

    private static class Order {
        private final int id;
        private final Map<String, String> data;

        public Order(int id, Map<String, String> data) {
            this.id = id;
            this.data = data;
        }

        public int getId() {
            return this.id;
        }

        public Map<String, String> getData() {
            return this.data;
        }
    }
}

