/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class SplitterShareUnitOfWorkCompletionAwareTest
extends ContextTestSupport {
    @Test
    public void testCompletionAware() throws Exception {
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+B+C"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"bar");
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body(), (AggregationStrategy)new MyStrategy()).shareUnitOfWork().to("mock:line")).end().to("mock:result");
            }
        };
    }

    private static class MyStrategy
    implements AggregationStrategy {
        private MyStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = String.valueOf(oldExchange.getIn().getBody()) + "+" + String.valueOf(newExchange.getIn().getBody());
            oldExchange.getIn().setBody((Object)body);
            return oldExchange;
        }

        public void onCompletion(Exchange exchange) {
            exchange.getIn().setHeader("foo", (Object)"bar");
        }
    }
}

