/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterPojoTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("mySplitterBean", (Object)new MySplitterBean());
        return jndi;
    }

    @Test
    public void testSplitBodyWithPojoBean() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"James", "Jonathan", "Hadrian", "Claus", "Willem"});
        this.template.sendBody("direct:body", (Object)"James,Jonathan,Hadrian,Claus,Willem");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitMessageWithPojoBean() {
        String[] users = new String[]{"James", "Jonathan", "Hadrian", "Claus", "Willem"};
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.reset();
        mock.expectedMessageCount(5);
        this.template.sendBodyAndHeader("direct:message", (Object)"Test Body Message", "user", (Object)"James,Jonathan,Hadrian,Claus,Willem");
        int i = 0;
        for (Exchange exchange : mock.getExchanges()) {
            Assertions.assertEquals((Object)"Test Body Message", (Object)exchange.getIn().getBody(), (String)"We got a wrong body ");
            Assertions.assertEquals((Object)users[i], (Object)exchange.getIn().getHeader("user"), (String)"We got a wrong header ");
            ++i;
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:body").split().method("mySplitterBean", "splitBody")).to("mock:result");
                ((SplitDefinition)this.from("direct:message").split().method("mySplitterBean", "splitMessage")).to("mock:result");
            }
        };
    }

    public static class MySplitterBean {
        public List<String> splitBody(String body) {
            String[] parts = body.split(",");
            ArrayList<String> answer = new ArrayList<String>(Arrays.asList(parts));
            return answer;
        }

        public List<Message> splitMessage(@Header(value="user") String header, @Body String body, CamelContext camelContext) {
            String[] parts;
            ArrayList<Message> answer = new ArrayList<Message>();
            for (String part : parts = header.split(",")) {
                DefaultMessage message = new DefaultMessage(camelContext);
                message.setHeader("user", (Object)part);
                message.setBody((Object)body);
                answer.add((Message)message);
            }
            return answer;
        }
    }
}

