/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SplitterParallelStopOnExceptionTest
extends ContextTestSupport {
    private ExecutorService service;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.service = Executors.newFixedThreadPool(2);
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.service.shutdownNow();
    }

    @Test
    public void testSplitParallelStopOnExceptionOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitParallelStopOnExceptionStop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMinimumMessageCount(0);
        ((MockValueBuilder)mock.allMessages().body()).isNotEqualTo((Object)"Kaboom");
        try {
            this.template.sendBody("direct:start", (Object)"Hello World,Goodday World,Kaboom,Bye World");
            Assertions.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException cause = SplitterParallelStopOnExceptionTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            Assertions.assertTrue((boolean)cause.getMessage().startsWith("Multicast processing failed for number "));
            Assertions.assertEquals((Object)"Forced", (Object)cause.getCause().getMessage());
            String body = (String)cause.getExchange().getIn().getBody(String.class);
            Assertions.assertTrue((boolean)body.contains("Kaboom"));
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).parallelProcessing().stopOnException().executorService(SplitterParallelStopOnExceptionTest.this.service).process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                })).to("mock:split");
            }
        };
    }
}

