/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Manual test")
public class SplitterParallelBigFileManualTest
extends ContextTestSupport {
    @Test
    public void testSplitParallelBigFile() throws Exception {
        Path dir = this.testDirectory();
        Files.createDirectories(dir, new FileAttribute[0]);
        int lines = 20000;
        try (OutputStream fos = Files.newOutputStream(this.testFile("bigfile.txt"), new OpenOption[0]);){
            for (int i = 0; i < lines; ++i) {
                String line = "line-" + i + LS;
                fos.write(line.getBytes());
            }
        }
        StopWatch watch = new StopWatch();
        NotifyBuilder builder = new NotifyBuilder((CamelContext)this.context).whenDone(lines + 1).create();
        boolean done = builder.matches(120L, TimeUnit.SECONDS);
        this.log.info("Took {}", (Object)TimeUtils.printDuration((long)watch.taken(), (boolean)true));
        if (!done) {
            throw new CamelException("Could not split file in 2 minutes");
        }
        Thread.sleep(60000L);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from(SplitterParallelBigFileManualTest.this.fileUri("?initialDelay=0&delay=10")).split((Expression)this.body().tokenize(LS)).streaming().parallelProcessing().to("log:split?groupSize=1000")).end().log("Done splitting ${file:name}");
            }
        };
    }
}

