/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;

@EnabledIfSystemProperty(named="core.manual.tests", matches="true", disabledReason="Manual test")
public class SplitterParallelAggregateManualTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:splitSynchronizedAggregation").split((Expression)this.method(new MySplitter(), "rowIterator"), (AggregationStrategy)new MyAggregationStrategy()).to("log:someSplitProcessing?groupSize=500");
                this.from("direct:splitUnsynchronizedAggregation").split((Expression)this.method(new MySplitter(), "rowIterator"), (AggregationStrategy)new MyAggregationStrategy()).parallelAggregate().to("log:someSplitProcessing?groupSize=500");
            }
        };
    }

    @Test
    public void test1() throws Exception {
        int numberOfRequests = 1;
        this.timeSplitRoutes(numberOfRequests);
    }

    @Test
    public void test2() throws Exception {
        int numberOfRequests = 2;
        this.timeSplitRoutes(numberOfRequests);
    }

    @Test
    public void test4() throws Exception {
        int numberOfRequests = 4;
        this.timeSplitRoutes(numberOfRequests);
    }

    protected void timeSplitRoutes(int numberOfRequests) throws Exception {
        String[] endpoints = new String[]{"direct:splitSynchronizedAggregation", "direct:splitUnsynchronizedAggregation"};
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        StopWatch stopWatch = new StopWatch(false);
        for (String endpoint : endpoints) {
            stopWatch.restart();
            for (int requestIndex = 0; requestIndex < numberOfRequests; ++requestIndex) {
                futures.add(this.template.asyncRequestBody(endpoint, null, String.class));
            }
            for (int i = 0; i < futures.size(); ++i) {
                Future future = (Future)futures.get(i);
                future.get();
            }
            stopWatch.taken();
            this.log.info("test{}.{}={}\n", new Object[]{numberOfRequests, endpoint, stopWatch.taken()});
        }
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            Random random = new Random(System.currentTimeMillis());
            for (int i = 0; i < 10000; ++i) {
                random.nextGaussian();
            }
            return newExchange;
        }
    }

    public static class MySplitter {
        public Iterator<String[]> rowIterator() {
            LinkedList<String[]> rows = new LinkedList<String[]>();
            for (int i = 0; i < 10000; ++i) {
                String[] row = new String[10];
                for (int j = 0; j < row.length; ++j) {
                    row[j] = String.valueOf(System.nanoTime());
                }
                rows.add(row);
            }
            return rows.iterator();
        }
    }
}

