/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Animal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterOnPrepareTest
extends ContextTestSupport {
    @Test
    public void testSplitterOnPrepare() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        ((MockValueBuilder)this.getMockEndpoint("mock:a").allMessages().body(String.class)).isEqualTo((Object)"1 Tony the Tiger");
        ArrayList<Animal> animals = new ArrayList<Animal>();
        animals.add(new Animal(1, "Tiger"));
        animals.add(new Animal(1, "Tiger"));
        this.template.sendBody("direct:start", animals);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.body()).onPrepare((Processor)new FixNamePrepare()).to("direct:a");
                ((RouteDefinition)this.from("direct:a").process((Processor)new ProcessorA())).to("mock:a");
            }
        };
    }

    public static final class FixNamePrepare
    implements Processor {
        public void process(Exchange exchange) {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            Assertions.assertEquals((int)1, (int)body.getId());
            Assertions.assertEquals((Object)"Tiger", (Object)body.getName());
            body.setName("Tony the Tiger");
        }
    }

    public static class ProcessorA
    implements Processor {
        public void process(Exchange exchange) {
            Animal body = (Animal)exchange.getIn().getBody(Animal.class);
            Assertions.assertEquals((int)1, (int)body.getId());
            Assertions.assertEquals((Object)"Tony the Tiger", (Object)body.getName());
        }
    }
}

