/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterOnPrepareExceptionTest
extends ContextTestSupport {
    @Test
    public void testSplitterOnPrepare() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        String body = "Hello,Bye,Kaboom,Hi";
        try {
            this.template.sendBody("direct:start", (Object)body);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.body().tokenize(",")).onPrepare((Processor)new FixNamePrepare()).stopOnException().to("mock:a");
            }
        };
    }

    public static final class FixNamePrepare
    implements Processor {
        public void process(Exchange exchange) {
            String name = (String)exchange.getIn().getBody(String.class);
            if ("Kaboom".equals(name)) {
                throw new IllegalArgumentException("Forced error");
            }
        }
    }
}

