/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterOnCompletionTest
extends ContextTestSupport {
    @Test
    public void testSplitOk() throws Exception {
        this.getMockEndpoint("mock:done").expectedBodiesReceived(new Object[]{"Hello World,Bye World"});
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitException() throws Exception {
        this.getMockEndpoint("mock:done").expectedBodiesReceived(new Object[]{"Hello World,Kaboom,Bye World"});
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        try {
            this.template.sendBody("direct:start", (Object)"Hello World,Kaboom,Bye World");
            Assertions.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException iae = SplitterOnCompletionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"Forced", (Object)iae.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onCompletion().to(new String[]{"log:done", "mock:done"});
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).process((Processor)new MyProcessor())).to("mock:split");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kaboom".equals(body)) {
                throw new IllegalArgumentException("Forced");
            }
        }
    }
}

