/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class SplitterMethodCallTest
extends ContextTestSupport {
    @Test
    public void testSplitUsingMethodCall() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template.sendBody("direct:start", (Object)"Claus@James@Willem");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("splitterBean", (Object)new SplitWordsBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().method("splitterBean", "splitWords")).to("mock:result");
            }
        };
    }

    public static final class SplitWordsBean {
        private SplitWordsBean() {
        }

        public static List<String> splitWords(String body) {
            return Arrays.asList(body.split("@"));
        }
    }
}

