/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Test;

public class SplitterMapTest
extends ContextTestSupport {
    @Test
    public void testSplitMap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:line");
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"Hello World");
        ((MockValueBuilder)mock.message(0).header("myKey")).isEqualTo((Object)"123");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"Bye World");
        ((MockValueBuilder)mock.message(1).header("myKey")).isEqualTo((Object)"789");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("123", "Hello World");
        map.put("789", "Bye World");
        this.template.sendBody("direct:start", map);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ProcessorDefinition)this.from("direct:start").split((Expression)this.body()).setHeader("myKey").simple("${body.key}")).setBody((Expression)this.simple("${body.value}"))).to("mock:line");
            }
        };
    }
}

