/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class SplitterCompletedPropertyTest
extends ContextTestSupport {
    @Test
    public void testSplitterCompleted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World", "Bye Moon"});
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelSplitComplete")).isEqualTo((Object)false);
        ((MockValueBuilder)mock.message(1).exchangeProperty("CamelSplitComplete")).isEqualTo((Object)false);
        ((MockValueBuilder)mock.message(2).exchangeProperty("CamelSplitComplete")).isEqualTo((Object)true);
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World,Bye Moon");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitterStreamingCompleted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World", "Bye Moon"});
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelSplitComplete")).isEqualTo((Object)false);
        ((MockValueBuilder)mock.message(1).exchangeProperty("CamelSplitComplete")).isEqualTo((Object)false);
        ((MockValueBuilder)mock.message(2).exchangeProperty("CamelSplitComplete")).isEqualTo((Object)true);
        this.template.sendBody("direct:streaming", (Object)"Hello World,Bye World,Bye Moon");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.body().tokenize(",")).to("mock:split");
                this.from("direct:streaming").split((Expression)this.body().tokenize(",")).streaming().to("mock:split");
            }
        };
    }
}

