/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterCollateTest
extends ContextTestSupport {
    @Test
    public void testSplitterCollate() throws Exception {
        this.getMockEndpoint("mock:line").expectedMessageCount(2);
        ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        data.add("D");
        data.add("E");
        this.template.sendBody("direct:start", data);
        this.assertMockEndpointsSatisfied();
        List chunk = (List)((Exchange)this.getMockEndpoint("mock:line").getReceivedExchanges().get(0)).getIn().getBody(List.class);
        List chunk2 = (List)((Exchange)this.getMockEndpoint("mock:line").getReceivedExchanges().get(1)).getIn().getBody(List.class);
        Assertions.assertEquals((int)3, (int)chunk.size());
        Assertions.assertEquals((int)2, (int)chunk2.size());
        Assertions.assertEquals((Object)"A", chunk.get(0));
        Assertions.assertEquals((Object)"B", chunk.get(1));
        Assertions.assertEquals((Object)"C", chunk.get(2));
        Assertions.assertEquals((Object)"D", chunk2.get(0));
        Assertions.assertEquals((Object)"E", chunk2.get(1));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.simple("${collate(3)}")).to("mock:line");
            }
        };
    }
}

