/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitterAggregationStrategyPropagateVariableAsResultTest
extends ContextTestSupport {
    @Test
    public void testSplitVariable() throws Exception {
        this.getMockEndpoint("mock:split").expectedMessageCount(3);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
        MockEndpoint result = this.getMockEndpoint("mock:result");
        Exchange e = (Exchange)result.getExchanges().get(0);
        Assertions.assertNotNull((Object)e);
        Assertions.assertTrue((boolean)e.hasProperties());
        List l = (List)e.getProperty("REP_PROP", List.class);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((int)3, (int)l.size());
        Assertions.assertEquals((Object)"A", l.get(0));
        Assertions.assertEquals((Object)"B", l.get(1));
        Assertions.assertEquals((Object)"C", l.get(2));
        Assertions.assertTrue((boolean)e.getMessage().hasHeaders());
        l = (List)e.getMessage().getHeader("REP_HEAD", List.class);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((int)3, (int)l.size());
        Assertions.assertEquals((Object)"A", l.get(0));
        Assertions.assertEquals((Object)"B", l.get(1));
        Assertions.assertEquals((Object)"C", l.get(2));
        Assertions.assertTrue((boolean)e.hasVariables());
        l = (List)e.getVariable("REP_VAL", List.class);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((int)3, (int)l.size());
        Assertions.assertEquals((Object)"A", l.get(0));
        Assertions.assertEquals((Object)"B", l.get(1));
        Assertions.assertEquals((Object)"C", l.get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(","), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        String newBody = (String)newExchange.getMessage().getBody(String.class);
                        if (oldExchange == null) {
                            ArrayList<String> bodies = new ArrayList<String>();
                            ArrayList<String> properties = new ArrayList<String>();
                            ArrayList<String> headers = new ArrayList<String>();
                            ArrayList<String> variables = new ArrayList<String>();
                            bodies.add(newBody);
                            properties.add(newBody);
                            headers.add(newBody);
                            variables.add(newBody);
                            newExchange.getMessage().setBody(bodies);
                            newExchange.getMessage().setHeader("REP_HEAD", headers);
                            newExchange.setProperty("REP_PROP", properties);
                            newExchange.setVariable("REP_VAL", variables);
                            return newExchange;
                        }
                        List bodies = (List)oldExchange.getMessage().getBody(List.class);
                        List properties = (List)oldExchange.getProperty("REP_PROP", List.class);
                        List headers = (List)oldExchange.getMessage().getHeader("REP_HEAD", List.class);
                        List variable = (List)oldExchange.getVariable("REP_VAL", List.class);
                        bodies.add(newBody);
                        properties.add(newBody);
                        headers.add(newBody);
                        variable.add(newBody);
                        return oldExchange;
                    }
                }).to("mock:split")).end().to("mock:result");
            }
        };
    }
}

