/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.TransformProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitWithEndTest
extends ContextTestSupport {
    @Test
    public void testRouteIsCorrectAtRuntime() {
        Navigate nav = ((Route)this.context.getRoutes().get(0)).navigate();
        List node = nav.next();
        Assertions.assertEquals((int)4, (int)node.size());
        SplitWithEndTest.assertIsInstanceOf(SendProcessor.class, SplitWithEndTest.unwrapChannel((Processor)node.get(0)).getNextProcessor());
        SplitWithEndTest.assertIsInstanceOf(Splitter.class, SplitWithEndTest.unwrapChannel((Processor)node.get(1)).getNextProcessor());
        SplitWithEndTest.assertIsInstanceOf(TransformProcessor.class, SplitWithEndTest.unwrapChannel((Processor)node.get(2)).getNextProcessor());
        SplitWithEndTest.assertIsInstanceOf(SendProcessor.class, SplitWithEndTest.unwrapChannel((Processor)node.get(3)).getNextProcessor());
    }

    @Test
    public void testSplit() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Hello,World,Moon"});
        this.getMockEndpoint("mock:last").expectedBodiesReceived(new Object[]{"last hi Hello@hi World@hi Moon"});
        this.template.sendBody("direct:start", (Object)"Hello,World,Moon");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                SplitWithEndTest.this.context.setTracing(Boolean.valueOf(true));
                MySplitBean bean = new MySplitBean();
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:start").to("mock:start")).split((Expression)this.body().tokenize(","), new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        String newBody = (String)newExchange.getIn().getBody(String.class);
                        newExchange.getIn().setBody((Object)(body + "@" + newBody));
                        return newExchange;
                    }
                }).bean((Object)bean, "hi")).to("mock:split")).to("log:foo")).end().transform((Expression)this.body().prepend((Object)"last ")).to("mock:last");
            }
        };
    }

    public static class MySplitBean {
        public String hi(String s) {
            return "hi " + s;
        }
    }
}

