/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class SplitWithDelimiterTest
extends ContextTestSupport {
    @Test
    public void testSplitWithDelimiterDisabled() throws Exception {
        String body = "some , # false text";
        MockEndpoint m = this.getMockEndpoint("mock:result-0");
        m.expectedPropertyReceived("CamelSplitSize", (Object)1);
        m.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:start-0", (Object)body);
        m.assertIsSatisfied();
    }

    @Test
    public void testSplitWithDefaultDelimiter() throws Exception {
        String body = "some , # false text";
        MockEndpoint m = this.getMockEndpoint("mock:result-1");
        m.expectedPropertyReceived("CamelSplitSize", (Object)2);
        this.template.sendBody("direct:start-1", (Object)body);
        m.expectedBodiesReceived(new Object[]{"some ", " # false text"});
        m.assertIsSatisfied();
    }

    @Test
    public void testSplitWithDelimiter() throws Exception {
        String body = "some , # false # text";
        MockEndpoint m = this.getMockEndpoint("mock:result-2");
        m.expectedPropertyReceived("CamelSplitSize", (Object)3);
        m.expectedBodiesReceived(new Object[]{"some , ", " false ", " text"});
        this.template.sendBody("direct:start-2", (Object)body);
        m.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start-0").split((Expression)this.body(), "false").to("mock:result-0");
                this.from("direct:start-1").split((Expression)this.body()).to("mock:result-1");
                this.from("direct:start-2").split((Expression)this.body(), "#").to("mock:result-2");
            }
        };
    }
}

