/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitTwoSubUnitOfWorkTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testOK() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Tiger", "Camel"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Elephant", "Lion"});
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Tiger", "Camel", "Elephant", "Lion"});
        MyBody body = new MyBody("Tiger,Camel", "Elephant,Lion");
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testError() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:dead").message(0).body()).isInstanceOf(MyBody.class);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Tiger", "Camel"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Elephant", "Donkey"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"Tiger", "Camel", "Elephant"});
        MyBody body = new MyBody("Tiger,Camel", "Elephant,Donkey");
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
        MyBody dead = (MyBody)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getIn().getBody(MyBody.class);
        Assertions.assertSame((Object)body, (Object)dead, (String)"Should be original message in DLC");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").useOriginalMessage().maximumRedeliveries(3).redeliveryDelay(0L));
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:start").to("mock:a")).split((Expression)this.simple("${body.foo}")).shareUnitOfWork().to("mock:b")).to("direct:line")).end().split((Expression)this.simple("${body.bar}")).shareUnitOfWork().to("mock:c")).to("direct:line")).end().to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:line").to("log:line")).process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body.contains("Donkey")) {
                            ++counter;
                            throw new IllegalArgumentException("Donkey not allowed");
                        }
                    }
                })).to("mock:line");
            }
        };
    }

    public static final class MyBody {
        private final String foo;
        private final String bar;

        private MyBody(String foo, String bar) {
            this.foo = foo;
            this.bar = bar;
        }

        public String getFoo() {
            return this.foo;
        }

        public String getBar() {
            return this.bar;
        }
    }
}

