/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;

public class SplitTokenizerXmlMultilineTest
extends ContextTestSupport {
    @Test
    public void testSingleLine() throws Exception {
        String payload = "<Parent>\n\t<Child A=\"1\" B=\"2\"/>\n</Parent>";
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)payload);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMultipleLines() throws Exception {
        String payload = "<Parent>\n\t<Child A=\"1\"\n\tB=\"2\"/>\n</Parent>";
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)payload);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().tokenizeXML("Child")).to("mock:result");
            }
        };
    }
}

