/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.language.TokenizerExpression;
import org.junit.jupiter.api.Test;

public class SplitTokenizerTest
extends ContextTestSupport {
    @Test
    public void testSplitTokenizerA() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template.sendBody("direct:a", (Object)"Claus,James,Willem");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitTokenizerB() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template.sendBodyAndHeader("direct:b", (Object)"Hello World", "myHeader", (Object)"Claus,James,Willem");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitTokenizerC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template.sendBody("direct:c", (Object)"Claus James Willem");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitTokenizerD() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"[Claus]", "[James]", "[Willem]"});
        this.template.sendBody("direct:d", (Object)"[Claus][James][Willem]");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitTokenizerE() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"<person>Claus</person>", "<person>James</person>", "<person>Willem</person>"});
        String xml = "<persons><person>Claus</person><person>James</person><person>Willem</person></persons>";
        this.template.sendBody("direct:e", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitTokenizerEWithSlash() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        String xml = "<persons><person attr='/' /></persons>";
        mock.expectedBodiesReceived(new Object[]{"<person attr='/' />"});
        this.template.sendBody("direct:e", (Object)xml);
        mock.assertIsSatisfied();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitTokenizerF() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"<person name=\"Claus\"/>", "<person>James</person>", "<person>Willem</person>"});
        String xml = "<persons><person/><person name=\"Claus\"/><person>James</person><person>Willem</person></persons>";
        this.template.sendBody("direct:f", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:a").split().tokenize(",")).to("mock:split");
                TokenizerExpression byHeader = ((TokenizerExpression.Builder)this.expression().tokenize().token(",").source("header:myHeader")).end();
                this.from("direct:b").split((Expression)byHeader).to("mock:split");
                ((SplitDefinition)this.from("direct:c").split().tokenize("(\\W+)\\s*", true)).to("mock:split");
                ((SplitDefinition)this.from("direct:d").split().tokenizePair("[", "]", true)).to("mock:split");
                ((SplitDefinition)this.from("direct:e").split().tokenizeXML("person")).to("mock:split");
                ((FilterDefinition)((SplitDefinition)this.from("direct:f").split().xpath("//person")).filter().simple("${body}")).to("mock:split");
            }
        };
    }
}

