/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.language.TokenizerExpression;
import org.junit.jupiter.api.Test;

public class SplitTokenizerRegexpGroupTest
extends ContextTestSupport {
    @Test
    public void testSplitTokenizer() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:line");
        mock.expectedBodiesReceived(new Object[]{"Claus\nJames", "Willem\nJon", "Andrea"});
        this.template.sendBody("direct:start", (Object)"Header\nClaus\r\nJames\nWillem\r\nJon\nAndrea");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                TokenizerExpression token = this.expression().tokenize().token("\r\n|\n").regex(true).group(2).groupDelimiter("\n").skipFirst(true).end();
                this.from("direct:start").split((Expression)token).to("mock:line");
            }
        };
    }
}

