/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;

public class SplitTokenizerGroupDynamicTest
extends ContextTestSupport {
    @Test
    public void testSplitTokenizerA() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus,James", "Willem"});
        this.template.sendBodyAndHeader("direct:a", (Object)"Claus,James,Willem", "groups", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitTokenizerB() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"James,Willem"});
        this.template.sendBodyAndHeader("direct:b", (Object)"Claus,James,Willem".getBytes(), "groups", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:a").split().tokenize(",", false, "${header.groups}")).to("mock:split");
                this.from("direct:b").split((Expression)this.bodyAs(String.class).tokenize(",", "${header.groups}", true)).to("mock:split");
            }
        };
    }
}

