/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.ThreadPoolProfile;
import org.junit.jupiter.api.Test;

public class SplitTimeoutCancelTaskTest
extends ContextTestSupport {
    final String payload1 = "<items><item><id>1</id><name>one</name></item><item><id>2</id><name>two</name></item></items>";
    final String payload2 = "<items><item><id>3</id><name>three</name></item><item><id>4</id><name>four</name></item></items>";

    @Test
    public void testSplitterTimeoutShouldNotExhaustThreadPool() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:split");
        mockEndpoint.expectedMessageCount(4);
        this.template.sendBody("direct:start", (Object)"<items><item><id>1</id><name>one</name></item><item><id>2</id><name>two</name></item></items>");
        this.template.sendBody("direct:start", (Object)"<items><item><id>3</id><name>three</name></item><item><id>4</id><name>four</name></item></items>");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThreadPoolProfile myThreadPoolProfile = new ThreadPoolProfile("testProfile");
                myThreadPoolProfile.setMaxPoolSize(Integer.valueOf(20));
                myThreadPoolProfile.setPoolSize(Integer.valueOf(10));
                myThreadPoolProfile.setMaxQueueSize(Integer.valueOf(1));
                this.getContext().getExecutorServiceManager().setDefaultThreadPoolProfile(myThreadPoolProfile);
                ((SplitDefinition)this.from("direct:start").split().xpath("//items/item")).parallelProcessing(true).streaming(true).stopOnException(true).timeout("30000").executorService("testProfile").to("mock:split");
            }
        };
    }
}

