/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitSubUnitOfWorkStopOnExceptionAndParallelTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testOK() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Tiger,Camel"});
        this.getMockEndpoint("mock:b").expectedBodiesReceivedInAnyOrder(new Object[]{"Tiger", "Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Tiger,Camel"});
        this.getMockEndpoint("mock:line").expectedBodiesReceivedInAnyOrder(new Object[]{"Tiger", "Camel"});
        this.template.sendBody("direct:start", (Object)"Tiger,Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testError() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Tiger,Donkey,Camel"});
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:line").expectedMinimumMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Tiger,Donkey,Camel");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").useOriginalMessage().maximumRedeliveries(3).redeliveryDelay(0L));
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:start").to("mock:a")).split((Expression)this.body().tokenize(",")).shareUnitOfWork().stopOnException().parallelProcessing().to("mock:b")).to("direct:line")).end().to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:line").to("log:line")).process((Processor)new MyProcessor())).to("mock:line");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.contains("Donkey")) {
                ++counter;
                throw new IllegalArgumentException("Donkey not allowed");
            }
        }
    }
}

