/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class SplitRefCustomExpressionTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myCustomExpression", (Object)new MyCustomExpression());
        return jndi;
    }

    @Test
    public void testSplitCustomExpression() throws Exception {
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().ref("myCustomExpression")).to("mock:split");
            }
        };
    }

    public static class MyCustomExpression
    implements Expression {
        public <T> T evaluate(Exchange exchange, Class<T> type) {
            String body = (String)exchange.getIn().getBody(String.class);
            String[] parts = body.split(",");
            List<String> list = List.of(parts);
            return (T)list.iterator();
        }
    }
}

