/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Timeout(value=60L)
public class SplitParallelTimeoutTest
extends ContextTestSupport {
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;
    private final Phaser phaser = new Phaser(3);

    @BeforeEach
    void sendEarly() {
        Assumptions.assumeTrue((boolean)this.context.isStarted(), (String)"The test cannot be run because the context is not started");
        this.template.sendBody("direct:start", (Object)"A,B,C");
    }

    @RepeatedTest(value=10)
    public void testSplitParallelTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)mock.message(0).body()).not(SplitParallelTimeoutTest.body().contains((Object)"A"));
        this.phaser.awaitAdvanceInterruptibly(0, 5000L, TimeUnit.SECONDS);
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)this.receivedExchange);
        Assertions.assertEquals((int)0, (int)this.receivedIndex);
        Assertions.assertEquals((int)3, (int)this.receivedTotal);
        Assertions.assertEquals((long)100L, (long)this.receivedTimeout);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").split((Expression)this.body().tokenize(","), (AggregationStrategy)new MyAggregationStrategy()).parallelProcessing().timeout(100L).choice().when(this.body().isEqualTo((Object)"A")).to("direct:a")).when(this.body().isEqualTo((Object)"B")).to("direct:b")).when(this.body().isEqualTo((Object)"C")).to("direct:c")).end().end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").process(e -> SplitParallelTimeoutTest.this.phaser.arriveAndAwaitAdvance())).delay(200L).setBody((Expression)this.constant("A"));
                ((RouteDefinition)this.from("direct:b").process(e -> SplitParallelTimeoutTest.this.phaser.arriveAndAwaitAdvance())).setBody((Expression)this.constant("B"));
                ((RouteDefinition)this.from("direct:c").process(e -> SplitParallelTimeoutTest.this.phaser.arriveAndAwaitAdvance())).delay(10L).setBody((Expression)this.constant("C"));
            }
        };
    }

    private class MyAggregationStrategy
    implements AggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            SplitParallelTimeoutTest.this.receivedExchange = oldExchange;
            SplitParallelTimeoutTest.this.receivedIndex = index;
            SplitParallelTimeoutTest.this.receivedTotal = total;
            SplitParallelTimeoutTest.this.receivedTimeout = timeout;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
            return oldExchange;
        }
    }
}

